/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.server.IPECommands;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;

abstract class VWStatistics
implements Serializable {
    private static final long serialVersionUID = 7444L;
    protected Date evaluationTime = null;
    protected Date startTime = null;
    protected Date endTime = null;
    protected Date userStartTime = null;
    protected Date userEndTime = null;
    protected int userTimeUnit;
    protected double numOfSamples;
    protected double numOfUnitsInPeriod;
    protected String className = null;
    protected Hashtable stats;
    protected IPECommands myCmdSession = null;

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 14:10:42  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.18  $";
    }

    protected VWStatistics(Hashtable result) throws VWException {
    }

    protected VWStatistics() throws VWException {
    }

    public Date getEvaluationTime() {
        return new Date(this.evaluationTime.getTime());
    }

    public Date getStartTime() {
        return new Date(this.startTime.getTime());
    }

    public Date getEndTime() {
        return new Date(this.endTime.getTime());
    }

    public Date getRequestedStartTime() {
        return new Date(this.userStartTime.getTime());
    }

    public Date getRequestedEndTime() {
        return new Date(this.userEndTime.getTime());
    }

    public int getRequestedTimeUnit() {
        return this.userTimeUnit;
    }

    public Double getNumberOfUnitsInPeriod() {
        return new Double(this.numOfUnitsInPeriod);
    }

    public Double getNumberOfSamples() {
        return new Double(this.numOfSamples);
    }

    public String getClassName() {
        return this.translateStr(this.className);
    }

    protected void setClassName(String name) {
        this.className = name;
    }

    public void setSession(IPECommands sess) throws VWException {
        this.myCmdSession = sess;
    }

    protected String translateStr(String inStr) {
        if (this.myCmdSession != null) {
            try {
                return this.myCmdSession.translate(inStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inStr;
    }
}

